---
generated_at: 2026-01-20 11:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-Hash Codes

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠が確認できたため、優先レビュー項目はありません

## 2) 参照した情報（Evidence一覧）

- E-01: `Examples/Cryptography/HashCodes/Form1.frm` 行3: BorderStyle = 1 'Fixed Single
- E-02: `Examples/Cryptography/HashCodes/Form1.frm` 行10-11: MaxButton = False, MinButton = False
- E-03: `Examples/Cryptography/HashCodes/Form1.frm` 行185-190: ハッシュオブジェクト宣言
- E-04: `Examples/Cryptography/HashCodes/Form1.frm` 行185: Private mSHA1 As New SHA1CryptoServiceProvider
- E-05: `Examples/Cryptography/HashCodes/Form1.frm` 行186: Private mSHA256 As New SHA256Managed
- E-06: `Examples/Cryptography/HashCodes/Form1.frm` 行189: Private mMD5 As New MD5CryptoServiceProvider
- E-07: `Examples/Cryptography/HashCodes/Form1.frm` 行190: Private mRIPEMD160 As New RIPEMD160Managed
- E-08: `Examples/Cryptography/HashCodes/Form1.frm` 行194-196: txtSource_Change
- E-09: `Examples/Cryptography/HashCodes/Form1.frm` 行199-209: ComputeHashes
- E-10: `Examples/Cryptography/HashCodes/Form1.frm` 行201: Encoding.UTF8.GetBytes
- E-11: `Examples/Cryptography/HashCodes/Form1.frm` 行211-222: DisplayHash
- E-12: `Examples/Cryptography/HashCodes/Form1.frm` 行16-30: txtSHA256 (MultiLine=True, Font=Courier 9.75pt)
- E-13: `docs/code-to-docs/画面一覧/画面一覧.csv` 行9: 画面情報定義
- E-14: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行70-77: 機能マッピング情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BorderStyle = Fixed Single でサイズ変更不可 | E-01 | ○ |
| C-02 | 最大化・最小化ボタン無効 | E-02 | ○ |
| C-03 | 6種類のハッシュオブジェクトをNew演算子で宣言 | E-03 | ○ |
| C-04 | SHA1CryptoServiceProviderを使用 | E-04 | ○ |
| C-05 | SHA256Managedを使用 | E-05 | ○ |
| C-06 | MD5CryptoServiceProviderを使用 | E-06 | ○ |
| C-07 | RIPEMD160Managedを使用 | E-07 | ○ |
| C-08 | txtSource_Changeでリアルタイム計算 | E-08 | ○ |
| C-09 | ComputeHashesで全アルゴリズム計算 | E-09 | ○ |
| C-10 | Encoding.UTF8.GetBytesで文字列変換 | E-10 | ○ |
| C-11 | DisplayHashで16進数表示 | E-11 | ○ |
| C-12 | Courierフォントで等幅表示 | E-12 | ○ |
| C-13 | 画面はサンプル/暗号化カテゴリ | E-13 | ○ |
| C-14 | SHA, MD5, RIPEMD160等の機能に関連 | E-14 | ○ |

## 4) 不足情報（Unknown / Missing）
- 現時点で根拠なしの項目はありません

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [x] 全ての主張にソースコード根拠が対応している
- [ ] MD5、SHA-1の脆弱性について理解（セキュリティ用途では非推奨）
- [ ] 各ハッシュアルゴリズムの出力長が正しいことを確認
